<?php
session_start();
require_once '../config/db.php';

// التحقق من صلاحية الدخول
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../src/login.php');
    exit;
}

// جلب المشاريع لاختيار المشروع
$projects = $pdo->query('SELECT id, name FROM projects ORDER BY id DESC')->fetchAll();

// إضافة مكان قريب جديد
if (isset($_POST['add_place'])) {
    $project_id = intval($_POST['project_id']);
    $place_type = $_POST['place_type'];
    $name = trim($_POST['name']);
    $map_url = trim($_POST['map_url']);
    $distance_km = floatval($_POST['distance_km']);
    $stmt = $pdo->prepare('INSERT INTO nearby_places (project_id, place_type, name, map_url, distance_km) VALUES (?, ?, ?, ?, ?)');
    $stmt->execute([$project_id, $place_type, $name, $map_url, $distance_km]);
}

// حذف مكان قريب
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare('DELETE FROM nearby_places WHERE id = ?');
    $stmt->execute([$id]);
}

// تعديل مكان قريب
if (isset($_POST['edit_place'])) {
    $id = intval($_POST['id']);
    $project_id = intval($_POST['project_id']);
    $place_type = $_POST['place_type'];
    $name = trim($_POST['name']);
    $map_url = trim($_POST['map_url']);
    $distance_km = floatval($_POST['distance_km']);
    $stmt = $pdo->prepare('UPDATE nearby_places SET project_id=?, place_type=?, name=?, map_url=?, distance_km=? WHERE id=?');
    $stmt->execute([$project_id, $place_type, $name, $map_url, $distance_km, $id]);
}

// جلب جميع الأماكن القريبة
$places = $pdo->query('SELECT n.*, p.name as project_name FROM nearby_places n LEFT JOIN projects p ON n.project_id = p.id ORDER BY n.id DESC')->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة الأماكن القريبة</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: #EEEEEE; font-family: 'Cairo', sans-serif; }
        .container { max-width: 1100px; margin: 40px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        h2 { color: #EA9218; margin-bottom: 24px; text-align: center; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 32px; }
        th, td { padding: 10px; border-bottom: 1px solid #EEEEEE; text-align: center; }
        th { background: #EA9218; color: #fff; }
        .btn { padding: 6px 16px; border-radius: 4px; border: none; cursor: pointer; }
        .btn-edit { background: #3A4750; color: #fff; }
        .btn-delete { background: #d00; color: #fff; }
        .form-inline input, .form-inline select { margin: 0 8px 8px 0; padding: 6px; }
        .form-inline { display: flex; flex-wrap: wrap; align-items: center; gap: 8px; margin-bottom: 24px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>إدارة الأماكن القريبة</h2>
        <!-- نموذج إضافة مكان قريب جديد -->
        <form class="form-inline" method="post">
            <select name="project_id" required>
                <option value="">اختر المشروع</option>
                <?php foreach ($projects as $project): ?>
                    <option value="<?= $project['id'] ?>"> <?= htmlspecialchars($project['name']) ?> </option>
                <?php endforeach; ?>
            </select>
            <select name="place_type" required>
                <option value="مدرسة">مدرسة</option>
                <option value="حديقة">حديقة</option>
                <option value="مسجد">مسجد</option>
                <option value="مجمع تجاري">مجمع تجاري</option>
                <option value="مستشفى">مستشفى</option>
            </select>
            <input type="text" name="name" placeholder="اسم المكان" required>
            <input type="url" name="map_url" placeholder="رابط الموقع" required>
            <input type="number" name="distance_km" placeholder="المسافة (كم)" step="0.01" required>
            <button class="btn" type="submit" name="add_place">إضافة مكان</button>
        </form>
        <!-- جدول الأماكن القريبة -->
        <table>
            <tr>
                <th>الرقم</th>
                <th>اسم المشروع</th>
                <th>نوع المكان</th>
                <th>اسم المكان</th>
                <th>رابط الموقع</th>
                <th>المسافة (كم)</th>
                <th>تعديل</th>
                <th>حذف</th>
            </tr>
            <?php foreach ($places as $place): ?>
            <tr>
                <form method="post">
                    <td><?= $place['id'] ?></td>
                    <td>
                        <select name="project_id" required>
                            <?php foreach ($projects as $project): ?>
                                <option value="<?= $project['id'] ?>" <?= $place['project_id']==$project['id']?'selected':'' ?>><?= htmlspecialchars($project['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                    <td>
                        <select name="place_type" required>
                            <option value="مدرسة" <?= $place['place_type']=='مدرسة'?'selected':'' ?>>مدرسة</option>
                            <option value="حديقة" <?= $place['place_type']=='حديقة'?'selected':'' ?>>حديقة</option>
                            <option value="مسجد" <?= $place['place_type']=='مسجد'?'selected':'' ?>>مسجد</option>
                            <option value="مجمع تجاري" <?= $place['place_type']=='مجمع تجاري'?'selected':'' ?>>مجمع تجاري</option>
                            <option value="مستشفى" <?= $place['place_type']=='مستشفى'?'selected':'' ?>>مستشفى</option>
                        </select>
                    </td>
                    <td><input type="text" name="name" value="<?= htmlspecialchars($place['name']) ?>" required></td>
                    <td><input type="url" name="map_url" value="<?= htmlspecialchars($place['map_url']) ?>" required></td>
                    <td><input type="number" name="distance_km" value="<?= $place['distance_km'] ?>" step="0.01" required></td>
                    <td>
                        <input type="hidden" name="id" value="<?= $place['id'] ?>">
                        <button class="btn btn-edit" type="submit" name="edit_place">تعديل</button>
                    </td>
                    <td>
                        <a class="btn btn-delete" href="?delete=<?= $place['id'] ?>" onclick="return confirm('هل أنت متأكد من حذف المكان؟');">حذف</a>
                    </td>
                </form>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>
